Example of using the SIM68K
---------------------------

Follow the procedure:

(1) At the DOS prompt, type

       EDIT EX1.ASM <enter>

(2) Type the following program: ( note that it is the same as EX1.ASM in 
    Workshop 2 but the address of DATA and PROG was changed to match the 
    SIM68K )

DATA    EQU     $1000           ( note the address is different from the
PROG    EQU     $1100             board using in the laboratory )

        ORG     DATA
VALUE1  DC.L    $12345678       FIRST VALUE
VALUE2  DC.L    $87654321       SECOND VALUE
RESULT  DS.L    1               RESERVE LONG WORD STORAGE

        ORG     PROG
        MOVEM.L VALUE1,D0/D1    LOAD VALUES TO BE COMPARED
        CMP.L   D0,D1           COMPARE 32 BIT VALUES
        BHI     STORE           IF VALUE2 > VALUE1 THEN GOTO STORE
        MOVE.L  D0,D1            ELSE D1 = VALUE1
STORE   MOVE.L  D1,RESULT       STORE LARGER VALUE
        NOP                     ( note that trap #11 routine is removed )
        END

(3) Select File-Exit from the editor menu and press <enter>.

(4) At the DOS prompt, type

       XASM EX1

(5) type

       SIM68K

(6) Press <CapsLock> to switch to capital letter since the simulator ONLY
    accepts CAPITAL LETTERS !!

(7) Type
       
       LO EX1.BIN
       MD 1100 13;DI
    
    The screen will display the instructions of your program

(8) Type

       MD 1000 10
    
    Record the contents of the memory

(9) Type 

       BR 1112
       GO 1100
    
    The program will execute from 1100 and stop at 1112

(10) Type

       MD 1000 10

     Record the contents of the memory again and compare the result with (8)

(11) Type

       EX

    The program will exit and return to DOS.

***********************************************************************

Here are the commands that the SIM68K simulator can use.
Note that these are taken from the book, "Computer Organisation and
the MC68000", by Panos E. Livadas and Christopher Ward, Prentice-Hall,
1993.  The authors of the book wrote the simulator and assembler and
are making them freely available.


The Simulator
*************

The simulator is able to simulate the Motorola "Educational Computer
Board", or ECB.  The ECB has a rather different address map from the
Flight-68K.  Also the ECB has similar firmware commands, but they have
different letters.  These are listed below.  The name of the simulator
is Sim68k.  The firmware in the ECB is called Tutor.

The Memory Map of the ECB (and Sim68k)
**************************************

Address range   Device  Use
000000-000007   ROM     Reset vector
000008-0003ff   RAM     Vector table
000400-0008FF   RAM     Tutor scratch pad
000900-007FFF   RAM     USER MEMORY <==============
008000-00BFFF   ROM     Tutor firmware
00C000-00FFFF           Unused

A 68230 PI/T and two 6850 UARTS are mapped above this, but the address
space there is otherwise empty.

NOTE that your program MUST be loaded into addresses LOWER than $7FFF,
but higher than $8FF.  The stack is usually at the top of RAM.

Sim68k firmware commands
************************

The Sim68k simulator is just software that runs on the PC and of
course contains no real firmware, but these are Tutor firmware
commands on the ECB.

ALL COMMANDS MUST BE ENTERED IN UPPER CASE LIKE THIS!

Getting started:
****************

1. Assemble your program with the assembler, asm68k.
2. Load your program into the simulator:        LO filename.s
3. Set the status register to $0700:            .SR 0700
4. Set the stack pointer to $7800:              .US 7800
5. Single step ("Trace") your program:          TR [<address>]
 OR
   Execute your program:                        GO [<address>]

List of firmware commands
*************************

[...] means that ... is optional.

DF              "Display Formatted" --- display the registers, like RD.
MD <address>    Memory dump
MD <address> ;DI        Disassemble
EX              exit the simulator
.<register>     Display <register>, eg  .D0 will display D0
                                        .A6 will display A6
                                        .A7 will display A7
                                        .SR will display SR
                                        .PC will display PC.
.<register> <data>      Modify <register>, eg   .D0 <data> will modify D0
                                        .A6 <data> will modify A6
                                        .A7 <data> will modify A7
                                        .SR <data> will modify SR
                                        .PC <data> will modfiy PC.
GO [<address>]  Run program non-stop
TR [<address>]  Single step
BR [<address>]  Set breakpoint---up to a maximum of eight.
NOBR [<address>]        Clear breakpoint
LO <filename>   Load filename into Sim68k.  File contains Motorola S records.
ST <filename> <address> <count> load <count> bytes starting at
                                        <address> and store into <filename>.
BF <address1> <address2> <data> Copy the hexadecimal word in <data> to
                        all addresses from <address1> to <address2>.
MM <address>    Modify one byte of memory.  Type . to terminate.
MM <address>;w  Modify one word of memory at a time.

The firmware remembers the last command you entered.  If you just type
a carriage return at the prompt, the last command will be processed
again.

Dissassembly works on one instruction the first time.  If you press
<Enter> straight after, you get 16 instructions dissassembled.


Monitor software interrupts
***************************

Like the Flight-68k, the ECB supports software interrupts.  There is a
difference in the way they are used: load a function number as a byte
into the D7 register then execute the instruction trap #14

        move.b  #<function number>,d7
        trap    #14

Here is a list of these I/O functions.  The function numbers are given
in decimal.

Function        Function
number          name

241             PORTIN1 Read string from keyboard into A6, terminate
                        with CR LF.
247             INCHE   As for PORTIN1 but terminated with CR with no LF
243             OUTPUT  Output string a6 points to to the screen
227             OUT1CR  As OUTPUT but also send CR LF.
248             OUTCH   Byte in D0 is output to screen
228             EXIT    Give termination message if Supervisor bit clear.

For more information see Appendix C of Livadas.

Use the correct simulator and assembler.
****************************************

Note that there are THREE simulators in the F:\SIM68K directory.  Use
Sim68k.exe.  There is one, xsim68k, that will run only under UNIX.
The other, sim68.exe, is a simulator for a simplified 68000.

Similarly there are two assemblers: use asm68k.  The other, asm68, is
an assembler for the simplified simulator.
