#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

/*
 *  There is a problem with istream::getline(char *buf, int len);
 *  If it doesn't reach the limit len, it gets the folowing '\n', whereas
 *  of it reaches the limit, it doesn't extract the following '\n'.
 *  This is possibly a bug.
 *  The long & short is that you can't rely on it to always remove
 *  the '\n'.  My solution is to use istream::get( char *, int);, which
 *  never gets the '\n', then to extract the '\n' with istream::ignore().
 *
 *  Nick Urbanik, 1-4-92.
 */

int main( void )
{
        const int maxline = 100;
        char line[ maxline ];
        ifstream fin( "abc.txt" );
        if ( ! fin ) {
                cerr << "Cannot open file abc.txt\n";
                exit( 1 );
        }
        while ( fin.getline( line, maxline ) )
                cout << line << endl;
}
