#include <iostream>
#include <fstream>
#include <stdlib.h>

/*
 *  There is a problem with istream::getline(char *buf, int len);
 *  If it doesn't reach the limit len, it gets the folowing '\n', whereas
 *  of it reaches the limit, it doesn't extract the following '\n'.
 *  This is possibly a bug.
 *  The long & short is that you can't rely on it to always remove
 *  the '\n'.  My solution is to use istream::get( char *, int);, which
 *  never gets the '\n', then to extract the '\n' with istream::ignore().
 *
 *  Nick Urbanik, 1-4-92.
 */

int main( int argc, char *argv[] )
{
        const int maxline = 100;
        char line[ maxline ];
        if ( argc != 2 ) {
                std::cerr << "fgets-arg filetoprint\n";
                exit( 1 );
        }
        std::ifstream fin( argv[ 1 ] );
        if ( ! fin ) {
                std::cerr << "Cannot open file\n";
                exit( 2 );
        }
        while ( fin.getline( line, maxline ) ) {
                std::cout << line << '\n';
        }
}
