#include <iostream>
#include <math.h>
#include <float.h>

// This program shows that floating point numbers do not hold every
// possible value, and many numbers cannot be represented exactly.

int main( void )
{
        // it would be much better to write something like this:
        // for ( double f = 0; f < 1.0; f += 1.0 / 9.0 ) {
        // or, to be certain to exclude the sum closest to 1.0:
        // for ( double f = 0; fabs( f - 1.0 ) > DBL_EPSILON; f += 1.0 / 9.0 ) {
        for ( double f = 0; f != 1.0; f += 1.0 / 9.0 ) {
                std::cout << "Add another nineth; f = " << f << '\n';
        }
}
