#include <stdio.h>
#include <windows.h>
#include <ioports.h>

/* NOTE:
        Don't forget to add the -l ioports option under Tools->Compiler options
        under "Add these commands to the linker command line"
        This will add the ioport interface library

        OR from the command line:
        
        gcc -Wall -o ledscan ledscan.c -l ioports
       
*/



/* Define which port to write to */

#define IO_PORT 0x378

int main(void)
{
    int i;
      
    printf("press ctrl-C to stop\n");
    
    /* Loop forever */
    while (1) {
          
          /* Count up in hex. 1, 2, 4, 8, 10, 20, 40, 80 */
          for (i=1; i<=0x80; i*=2) {
              outb(IO_PORT, i);       /* Output value to port */
              Sleep(300);             /* 300 mS pause */
          }
          /* Count down again */
          for (i=0x40; i>1; i/=2) {
              outb(IO_PORT, i);
              Sleep(300);
          }
    }
}
