#include <stdio.h>
#include <windows.h>


/* Definitions in the build of inpout32.dll are:            */
/*   short _stdcall Inp32(short PortAddress);               */
/*   void _stdcall Out32(short PortAddress, short data);    */


/* prototype (function typedef) for DLL function Inp32: */

typedef short _stdcall (*inpfuncPtr)(short portaddr);
typedef void _stdcall (*oupfuncPtr)(short portaddr, short datum);


short inb(short port)
{
     HINSTANCE hLib;
     inpfuncPtr inp32;
     short ret;

     /* Load the library */
     hLib = LoadLibrary("inpout32.dll");

     if (hLib == NULL) {
          printf("LoadLibrary Failed.\n");
          return -1;
     }

     /* get the address of the function */

     inp32 = (inpfuncPtr) GetProcAddress(hLib, "Inp32");

     if (inp32 == NULL) {
          printf("GetProcAddress for Inp32 Failed.\n");
          return -1;
     }
     ret = (inp32)(port);

     FreeLibrary(hLib);

     return(ret);

}

void outb(short port, short value)
{
     HINSTANCE hLib;
     oupfuncPtr oup32;

     /* Load the library */
     hLib = LoadLibrary("inpout32.dll");

     if (hLib == NULL) {
          printf("LoadLibrary Failed.\n");
          return;
     }

     /* get the address of the function */

     oup32 = (oupfuncPtr) GetProcAddress(hLib, "Out32");

     if (oup32 == NULL) {
          printf("GetProcAddress for Oup32 Failed.\n");
          return;
     }

     (oup32)(port, value);

     FreeLibrary(hLib);
}
