#! /bin/sh

prog=$(basename $0)

check_digits() {
    for d; do
        if ! echo $d | egrep -q '^[0-9]+$'
            then
            echo "$prog: value $d is not an integer"
            return 1
        fi
    done
    return 0
}

if [ $# -ne 4 ] || ! check_digits "$@"; then
    echo "$prog: Need 4 integer values a b c d to calculate a*20 - b*2 + c/d"
    exit 1
fi
a=$1 b=$2 c=$3 d=$4

[ $d -ne 0 ] || { echo Cannot divide by zero in \"$a*20 - $b*2 + $c/$d\";
    exit 1
}

let "result = a * 20 - b * 2 + c / d"
echo "The value of \"$a*20 - $b*2 + $c/$d\" is $result"
