#! /bin/sh

# This is an answer to Question 8:

# Modify the script you wrote for the previous question to print the
# output of rpm -K only for all the files that fail the test. In
# particular, if the package's gpg signature fails, then your script
# should display the output of rpm -K. There are at least two packages
# in this directory which do not have a valid gpg signature; one of
# them is redhat-release-7.2-1.noarch.rpm; what is the other?

# Here is output from rpm -K for two packages, one with no gpg
# signature, the other with:

# $ rpm -K redhat-release-7.2-1.noarch.rpm bash-2.05-8.i386.rpm
# redhat-release-7.2-1.noarch.rpm: md5 OK
# bash-2.05-8.i386.rpm: md5 gpg OK

# Test it in the same network directory as for the previous question.

echo *.rpm | grep -q '*.rpm' && {
    echo No RPM files in $PWD
    exit 1
}

for file in *.rpm
do
    RPMK=$(rpm -K $file) 2> /dev/null
    if ! echo $RPMK | grep -q 'gpg OK';then
        echo
        echo $file
        echo $RPMK
        echo
    else
        echo -n '.'
    fi
done
