% File: lab.cls
% For VTC microprocessor workshop and lab notes.
% Options: All article options and also:
% mechEng
% Written by Nick Urbanik, 14-10-94

% An example of the use of lab.cls:

% \documentclass{lab}
% \usepackage{lgrind,emlines2,multicol}
% Turn off lgrind's special handling of the vertical bar:
%|-

% \begin{document}
% \labHead

% \labTitle{2}{Reading an input device, using a new output device}

% \begin{objectives}
% \item To further practice the Edit/Compile/Download/Run process

% \item To understand more about how the interface board works with the
% 68230 parallel chip

% \item To understand how to read a keypad

% \item To learn a little more of the C language: specifically, about
% the bitwise operators AND (@&@), OR (@|@) and NOT (@~@), about
% comments, about arrays and about function parameters.

% \item To appreciate some tradeoffs between hardware and software in
% scanning a keypad
% \end{objectives}
% \vspace{-3.5ex}
% \begin{equipment}
% \item PC compatible computer

% \item Flight-68k 68000 microprocessor board with power supply
% and serial cable

% \item Hewlett Packard C cross compiler, assembler and linker

% \item Interface board with LEDs,
% switches and a cable to connect it to the Flight-68k board

% \item A text editor

% \item Microsoft Windows

% \item Manual for the Flight-68k board

% \item Manual for the 68230 parallel interface/timer (PI/T) chip
% \end{equipment}

% \vspace{-4ex}

% \tableofcontents

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% \section{Background information}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% End of example of the use of lab.cls.

% $Header: C:/EMTEX/TEXINPUT/RCS/lab.cls 1.9 1995/02/19 12:45:35 Nick Exp Nick $

% $Log: lab.cls $
% Revision 1.9  1995/02/19 12:45:35  Nick
% Major revision.
% Changed the headers and footers.
% Added revision control support for printing version numbers in lab sheets.
%
% Revision 1.8  1994/11/05  18:50:42  Nick
% Fixed missing comments.
% Moved \eemph into nick.sty.
% Fixed the overful box warning that got each page with fancyheadings
% Added Group field on front of lab sheet.
%
% Revision 1.7  1994/10/23  21:59:43  Nick
% Added varioref to list of packages used (it's indespensible!).
% Also fixed definition of eemph.
%
% Revision 1.6  1994/10/22  17:40:27  Nick
% 1. Have added an example of use of this class.
% 2. Have added some shorthand commands.
%
% Revision 1.5  1994/10/22  16:34:17  Nick
% Have added a subject number, and the mechEng option.
%

% Identification part

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{lab}[1994/10/22 For VTC microprocessor lab sheets]

% Declaration of options

% For Mechanical Engineering labs, need W. K. Leung's special codes: 
\DeclareOption{mechEng}{%
   \AtEndOfClass%
   {%
      \renewcommand{\subject}{Digital Electronics and Microprocessors}
      \renewcommand{\subjectNumber}{ME270}
   }%
}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

% Execution of options

\ProcessOptions

% Special class file commands

\LoadClass[a4paper,12pt]{article}

% Package loading

\RequirePackage{%
   vmargin,%
   nick,%
   varioref,%
   result,%
   fancyhea,%
   xspace,%
   rcs%
}

\setpapersize{A4}
%\setmarginsrb{25mm}{20mm}{25mm}{15mm}{12pt}{11mm}{0pt}{11mm}
%\setmarginsrb{25mm}{20mm}{35mm}{15mm}{12pt}{11mm}{0pt}{11mm}

\setmarginsrb{25mm}% left
             {16mm}% top
             {25mm}% right
             {15mm}% bottom
             {12pt}% headheight---increase to stop fancyhead warn
             {8mm}% headsep
             {0pt}%  footheight
             {11mm}% footskip

\shiftmargins

% These two lines fix up the overwritten page number problem in the
% table of contents:  Nick, 6-12-94.
\renewcommand\@pnumwidth{3.55em}
\renewcommand\@tocrmarg {4.55em}

\newcommand{\college}{Hong Kong Technical College (Tsing Yi)}
\newcommand{\subject}{Digital Systems and Microprocessors}
\newcommand{\subjectNumber}{EE270}
\newcommand{\department}%
      {Department of Electrical and Communications Engineering}
\newcommand{\up}{microprocessor\xspace}
\newcommand{\Up}{Microprocessor\xspace}
\providecommand{\ie}{i.e.,\xspace}
\providecommand{\eg}{e.g.,\xspace}

% Have moved \eemph into nick.sty, since it is so usefull.
% \newcommand{\eemph}[1]{\emph{\textbf{#1}}}

\newcommand{\DP}{\textsf{MS-DOS Prompt}\xspace}
\newcommand{\ed}{\textsf{MS-DOS Editor}\xspace}
\newcommand{\hp}{\textsf{HP Real-time C Debugger}\xspace}
\newcommand{\te}{\textsf{Terminal}\xspace}


% All the next section is to do the headings and footings:

%\renewcommand{\sectionmark}[1]{\markboth{\thesection\ #1}{\thesection\ #1}}
%\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
%\DeclareRobustCommand{\sectionmark}[1]{\markright{\thesection\ #1}}
%\DeclareRobustCommand{\sectionmark}[1]%
%     {\markright{\ifnum \c@secnumdepth >\m@ne
%            \thesection\hskip 1em\relax \fi
%            #1}}
% \DeclareRobustCommand{\sectionmark}[1]%
%      {\markboth{\thesection\hspace{1em}#1}{\thesection\hspace{1em}#1}}
% \DeclareRobustCommand{\chaptermark}[1]%
%      {\markboth{\thechapter\hspace{1em}#1}{\thechapter\hspace{1em}#1}}
% \DeclareRobustCommand{\subsectionmark}[1]%
%      {\markboth{\thesubsection\hspace{1em}#1}{\thesubsection\hspace{1em}#1}}
% \DeclareRobustCommand{\chaptermark}[1]%
%      {\markboth{\thesubsubsection\hspace{1em}#1}{\thesubsubsection\hspace{1em}#1}}

\renewcommand{\sectionmark}[1]%
     {\markright{\thesection\hspace{1em}#1}}
% \newcommand{\chaptermark}[1]%
%      {\markright{\thechapter\hspace{1em}#1}}
% \renewcommand{\subsectionmark}[1]%
%      {\markright{\thesubsection\hspace{1em}#1}}
% \renewcommand{\chaptermark}[1]%
%      {\markright{\thesubsubsection\hspace{1em}#1}}

% \if@twoside
%     \def\ps@headings{%
%       \let\@oddfoot\@empty\let\@evenfoot\@empty
%       \def\@evenhead{\thepage\hfil\slshape\leftmark}%
%       \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
%       \let\@mkboth\markboth
%       \def\sectionmark##1{%
%         \markboth {{\ifnum \c@secnumdepth >\z@
%             \thesection.\hskip 1em\relax\fi
%             ##1}}{}}%
%       \def\subsectionmark##1{%
%         \markright {\ifnum \c@secnumdepth >\@ne
%             \thesubsection\hskip 1em\relax \fi
%             ##1}}}
% \else
%     \def\ps@headings{%
%       \let\@oddfoot\@empty
%       \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
%       \let\@mkboth\markboth
%       \def\sectionmark##1{%
%         \markright {{\ifnum \c@secnumdepth >\m@ne
%             \thesection\hskip 1em\relax \fi
%             ##1}}}%
%       \def\subsectionmark##1{%
%         \markright {\ifnum \c@secnumdepth >\@ne
%             \thesubsection\hskip 1em\relax \fi
%             ##1}}%
%       \def\subsubsectionmark##1{%
%         \markright {\ifnum \c@secnumdepth >\@ne
%             \thesubsubsection\hskip 1em\relax \fi
%             ##1}}}
% \fi

% This stops the warnings about overfull boxes on each page, with
% fancypage.sty:
\addtolength{\headheight}{2.5pt}

% All changes to \textwidth to happen before here:
\pagestyle{fancyplain}

%
%     \lhead[\fancyplain{plain LH-even}{normal LH-even}]{\fancyplain{plain LH-odd}{normal LH-odd}}
%     \rhead[\fancyplain{plain RH-even}{normal RH-even}]{\fancyplain{plain RH-odd}{normal RH-odd}}
%

\lhead[\fancyplain{}%
      {\footnotesize\bfseries \subjectNumber\hspace{1em}\subject}]%
      {\fancyplain{}%
      {\footnotesize\bfseries \college}}

\rhead[\fancyplain{}
      {\footnotesize\bfseries \college}]%
      {\fancyplain{}%
      {\footnotesize\bfseries \subjectNumber\hspace{1em}\subject}}

\renewcommand{\thepage}{W\workshopNum-\arabic{page}}

\newlength{\markWidth}
\setlength{\markWidth}{\textwidth}
\addtolength{\markWidth}{-4em}

\setlength{\footrulewidth}{0.4pt}
% \lfoot[\fancyplain{}{\rmfamily\bfseries \thepage}]%
%       {\fancyplain{}{\footnotesize\bfseries\rightmark}}
\lfoot%
{%
   \fancyplain{\tiny \revision}%
   {%
      \parbox[t]{\markWidth}%
      {%
         \footnotesize\bfseries\rightmark\mdseries\tiny\mbox{}\\%
         \protect\revision%
      }%
   }%
}

% \lfoot%
% {%
%    \fancyplain{\tiny \revision}%
%    {%
%       \parbox[t]{\markWidth}%
%       {%
%          \protect\ifthenelse{\equal{\rightmark}{}}%
%             {}%
%             {\footnotesize\bfseries\rightmark\\}%
%          \mdseries\tiny\protect\revision%
%       }%
%    }%
% }

\cfoot{}
\rfoot[\fancyplain{}{\parbox[t]{\markWidth}{\footnotesize\bfseries\rightmark}}]%
      {\fancyplain{}{\rmfamily\bfseries \thepage}}


\newcommand{\labHead}{%
\thispagestyle{plain}
\begin{center}
\bfseries\large
\college

\department

\subjectNumber\hspace{1em}\subject

\end{center}

\vspace{4ex}

Name \rule{46mm}{.4pt} \hspace{6mm} Course, Group \rule{23mm}{.4pt} \hspace{6mm} Date \hrulefill\\
}

\newcommand{\labTitle}[3][Workshop]%
{%
   \let\workshopNum #2%
   \textbf{#1 #2: #3}%
}

\newenvironment{objectives}%
{%
   \begin{nameList}{Equipment:xx}
   \item[Objectives:]%
   \begin{thinEnumerate}
}%
{%
   \end{thinEnumerate}
   \end{nameList}%
}

\newenvironment{equipment}%
{%
   \begin{nameList}{Equipment:xx}
   \item[Equipment:]%
   \begin{thinEnumerate}
}%
{%
   \end{thinEnumerate}
   \end{nameList}%
}

\newenvironment{explanation}%
{%
   \begin{list}{}%
   {%
      \setlength{\parskip}{0.6em}
      \rightmargin \leftmargin
      \topsep 0pt%
   }%
   \small\item[]%
}%
{\end{list}}

% I copied this from lect.cls

\setcounter{secnumdepth}{5} % Number all headings.
\setcounter{tocdepth}{5}		% All headings go into table of contents.

% \newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
%                                      {-3.25ex\@plus -1ex \@minus -.2ex}%
%                                      {1.5ex \@plus .2ex}%
%                                      {\reset@font\normalsize\bfseries}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    %{-1em}%
                                     {0.75ex \@plus .2ex}%
                                    {\reset@font\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       %{-1em}%
                                      {0.5ex \@plus .2ex}%
                                      {\reset@font\normalsize\bfseries}}
