% File: lect.cls
% For VTC microprocessor lecture notes and slides.
% Options: All seminar and article options and also:
% slides, notes, mechEng
% Written by Nick Urbanik, 22-10-94
% An example of its use:

%\documentclass[slides,mechEng]{lect}

%\begin{document}
%\lectureHead

%\lectureTitle{1}{This is the heading for my test of the lect class}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\section{Background information}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The text about the topic of the background information...

% End of example of use of lect.cls.

% $Header: C:/EMTEX/TEXINPUT/RCS/lect.cls 1.11 1995/02/19 12:41:03 Nick Exp Nick $

% $Log: lect.cls $
% Revision 1.11  1995/02/19 12:41:03  Nick
% Major revision
% Have fixed the footers and headers with twoside option.
% Have added large numbers of other features and fixes.
%
% Revision 1.10  1994/11/06  22:33:56  Nick
% Have reorganised headers and footers so they don't overlap when use
% 12pt option.
% Have increased the bottom margin for notes.
% Could this be the final version?
%
% Revision 1.9  1994/11/06  09:19:29  Nick
% Added 1 pt to headheight to stop the overfull \vbox messages when use
% the 12pt option for notes.
%
% Revision 1.8  1994/11/05  22:16:31  Nick
% The margins were all wonky with the previous version for notes.
% Used vmargin to fix this.
%
% Revision 1.7  1994/11/05  19:04:00  Nick
% Reduced space between the subject number and subject name.
%
% Revision 1.6  1994/11/05  18:53:00  Nick
% Increased left margin on slides to make room for punching holes.
%
% Revision 1.5  1994/10/29  21:29:20  Nick
% Have changed the amrgins with vmargin.sty.
% The slides now have much smaller margins.  This seems to be what
% I aim for when photocopying.
% The margins are now down to about 7mm.  This is close to the limit of
% waht the photocopiers will copy to the edge of the transparency.
%
% Revision 1.4  1994/10/23  22:01:59  Nick
% added varioref to the packages loaded, since it is indespensable.
% Fixed the definition of \eemph.
% deleted unnessary flotsam and jetsam.
% Also added array.  Should consider adding hhline.sty to the list of
% packages.
% Added the \overbar command for active low processor pin names.
%
% Revision 1.2  1994/10/22  16:42:44  Nick
% Have added the subject number to the heading.  Minor typos fixed.
%

% Identification part

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{lect}[1994/10/22 For VTC microprocessor lectures]

% Declaration of options

% For slides, use a magnification of 1.2^3 = 216/125 = 1.728.
% This causes major overcrowding in the headers and footers, so
% careful rearrangement has remedied that mostly.
% Also have reduced the text in the title for the first page.

\DeclareOption{slides}{%
   \AtEndOfClass%
   {%
      \setmarginsrb{15mm}% leftmargin---was 7mm, now 15mm to allow for holes.
                   {4mm}%  topmargin
                   {7mm}%  rightmargin
                   {12mm}% bottommargin --- was 8mm
                   {5mm}%  headheight
                   {12pt}% headsep
                   {0pt}%  footheight---not defined in LaTeX 2e.
                   % Strange: set footskip to 10.25mm, get too much space
                   % between text and footer.  Set it to 10.24 and get way
                   % to little!  This looks like a bug ... no, maybe moves
                   % a line to the next page ...
                   {10.25mm}% footsep
      \articlemag{3}%
%     \addtolength{\footskip}{1pt}
      \addtolength{\headheight}{6.6pt}
      \renewcommand{\headwidth}{\textwidth}%
%
%     \lhead[\fancyplain{plain LH-even}{normal LH-even}]{\fancyplain{plain LH-odd}{normal LH-odd}}
%     \rhead[\fancyplain{plain RH-even}{normal RH-even}]{\fancyplain{plain RH-odd}{normal RH-odd}}
%
      \lhead[%
               \fancyplain{}%
               {%
                  \rmfamily\bfseries \thepage%
               }%
            ]%
            {%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \subjectNumber\hspace{0.5em}
                  \subject%
               }%
            }%
      \rhead[%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \subjectNumber\hspace{0.5em}
                  \subject%
               }%
            ]%
            {%
               \fancyplain{}%
               {\rmfamily\bfseries \thepage}%
            }%
%
      \lfoot[\fancyplain{}{}]%
            {%
               \fancyplain{\tiny\revision}%
               {%
                  \footnotesize\bfseries\rightmark\mdseries\tiny\mbox{}\\%
                  \protect\revision%
               }%
            }
      \rfoot[%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries\leftmark\mdseries\tiny\mbox{}\\%
                  \protect\revision%
               }%
            ]%
            {\fancyplain{}{}}
%
      \renewcommand{\lectureHead}%
      {%
         \thispagestyle{plain}
         \begin{center}
         \bfseries\large
         \subjectNumber\hspace{0.6em}\subject
         \end{center}
         \vspace{4ex}
      }%
   \setboolean{makeSLIDES}{true} % true for SLIDES
   \typeout{^^JMaking SLIDES^^J}
   }%
}

% Lecture notes to be handed out to students.
% Here we (try to) use the a4 style, a magnification of 0, more in the
% headers and footers, and more in the lecture heading.

\DeclareOption{notes}{%
   \AtEndOfClass%
   {%
      \setmarginsrb{30mm}%  leftmargin
                   {20mm}%  topmargin
                   {30mm}%  rightmargin
                   {20mm}%  bottommargin
                   {5mm}%  headheight
                   {8mm}% headsep
                   {0pt}%  footheight---not defined in LaTeX 2e.
                   % Strange: set footskip to 10.25mm, get too much space
                   % between text and footer.  Set it to 10.24 and get way
                   % to little!  This looks like a bug ... no, maybe moves
                   % a line to the next page ...
                   {10.25mm}% footskip
      \renewcommand{\headwidth}{\textwidth}%
      \newlength{\markWidth}
      \setlength{\markWidth}{\textwidth}
      \addtolength{\markWidth}{-3.5em}
%
      \addtolength{\headheight}{1.92ex}% Enough room for 2 lines in head.
%
%     \lhead[\fancyplain{plain LH-even}{normal LH-even}]{\fancyplain{plain LH-odd}{normal LH-odd}}
%     \rhead[\fancyplain{plain RH-even}{normal RH-even}]{\fancyplain{plain RH-odd}{normal RH-odd}}
%
      \lhead[%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \college%
               }%
            ]%
            {%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \subjectNumber\\
                  \subject%
               }%
            }%
%
      \rhead[%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \subjectNumber\\
                  \subject%
               }%
            ]%
            {%
               \fancyplain{}%
               {%
                  \footnotesize\bfseries \college%
               }%
            }%
%
      \lfoot[%
               \fancyplain{}%
               {%
                  \parbox[t]{\markWidth}%
                  {%
                     \footnotesize\bfseries\leftmark\mdseries\tiny\mbox{}\\%
                     \protect\revision%
                  }%
               }%
            ]%
            {%
               \fancyplain{\tiny\revision}%
               {%
                  \rmfamily\bfseries \thepage%
               }%
            }
%
      \rfoot[%
               \fancyplain{}%
               {%
                  \rmfamily\bfseries \thepage%
               }%
            ]%
            {%
               \fancyplain{}%
               {%
                  \parbox[t]{\markWidth}%
                  {%
                     \raggedleft%
                     \footnotesize\bfseries\rightmark\mdseries\tiny\mbox{}\\%
                     \protect\revision%
                  }%
               }%
            }
%
%      \rfoot[\fancyplain{}{\parbox[t]{\markWidth}{\hfill\footnotesize\bfseries\rightmark}}]%
%            {\fancyplain{}{\rmfamily\bfseries \thepage}}
%
   \setboolean{makeSLIDES}{false}% false for NOTES
   \typeout{^^JMaking NOTES^^J}
   }%
}

% For Mechanical Engineering lectures, need W. K. Leung's special codes: 
\DeclareOption{mechEng}{%
   \AtEndOfClass%
   {%
      \renewcommand{\subject}{Digital Electronics and Microprocessors}
      \renewcommand{\subjectNumber}{ME219}
   }%
}

% For Digital Logic and Microprocessor lectures, need W. K. Leung's special codes: 
\DeclareOption{logic}{%
   \AtEndOfClass%
   {%
      \renewcommand{\subjectNumber}{EE271}
      \renewcommand{\subject}{Digital Logic and Microprocessors}
   }%
}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{seminar}}

% Execution of options

\ProcessOptions

% Special class file commands

\LoadClass[a4,article,notesonly]{seminar}

% Package loading

\RequirePackage{%
   fancyhea,%
   xspace,%
   lgrind,%
   float,%
   varioref,%
   emlines2,%
   vmargin,%
   array,%
   nick,%
   ifthen,%
   verbatim,%
   rcs,%
   alltt}

% \typeout{^^JNow processing commands^^J}
\setpapersize{A4}
\shiftmargins

% true for makeing slides, false for making notes:
\newboolean{makeSLIDES}

\providecommand{\college}{Hong Kong Technical College (Tsing Yi)}
\providecommand{\subject}{Digital Systems and Microprocessors}
\providecommand{\subjectNumber}{EE270}
\providecommand{\department}%
      {Department of Electrical and Communications Engineering}
\providecommand{\up}{microprocessor\xspace}
\providecommand{\Up}{Microprocessor\xspace}
\providecommand{\ie}{i.e.,\xspace}
\providecommand{\eg}{e.g.,\xspace}
\providecommand{\hex}{$_{16}$\xspace}

% Moved definition of \eemph into nick.sty, since useful elsewhere.
% \providecommand{\eemph}[1]{\emph{\textbf{#1}}}
\providecommand{\overbar}[1]{\ensuremath{\overline{\mathrm{#1}}}}

% All the next section is to do the headings and footings:

\begin{comment}
%\renewcommand{\sectionmark}[1]{\markboth{\thesection\ #1}{\thesection\ #1}}
%\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
%\DeclareRobustCommand{\sectionmark}[1]{\markright{\thesection\ #1}}
\DeclareRobustCommand{\sectionmark}[1]%
     {\markright{\ifnum \c@secnumdepth >\m@ne
            \thesection\hskip 1em\relax \fi
            #1}}
%\DeclareRobustCommand{\sectionmark}[1]%
%     {\markboth{\thesection\ #1}{\thesection\ #1}}
\DeclareRobustCommand{\chaptermark}[1]%
     {\markboth{\thechapter\ #1}{\thechapter\ #1}}
\end{comment}

% All changes to \textwidth to happen before here:
\pagestyle{fancyplain}

\renewcommand{\thepage}{L\lectureNum-\arabic{page}}

\setlength{\footrulewidth}{0.4pt}
% \lfoot[\fancyplain{}{\rmfamily\bfseries \thepage}]%
%       {\fancyplain{}{\footnotesize\bfseries\rightmark}}
\cfoot{}
% \rfoot[\fancyplain{}{\footnotesize\bfseries\leftmark}]%
%       {\fancyplain{}{\rmfamily\bfseries \thepage}}


\newcommand{\lectureHead}{%
\thispagestyle{plain}
\begin{center}
\bfseries\large
\college

\department

\subjectNumber\hspace{1em}\subject

\end{center}

\vspace{4ex}
}

\newcommand{\lectureTitle}[3][Lecture]%
{%
   \newcommand{\lectureNum}{#2}%
   \textbf{\Large #1 #2: #3}%
}

\floatstyle{ruled}
\newfloat{Figure}{htbp}{lop}

\setcounter{secnumdepth}{5} % Number all headings.
\setcounter{tocdepth}{5}		% All headings go into table of contents.

% \newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
%                                      {-3.25ex\@plus -1ex \@minus -.2ex}%
%                                      {1.5ex \@plus .2ex}%
%                                      {\reset@font\normalsize\bfseries}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    %{-1em}%
                                     {0.75ex \@plus .2ex}%
                                    {\reset@font\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       %{-1em}%
                                      {0.5ex \@plus .2ex}%
                                      {\reset@font\normalsize\bfseries}}
% WARNING: BUG IN LGRIND.STY:
% ORIGINAL:
% \def\LGend{\ifLGd@fault\egroup\ifLGinline$\else$$\fi\LGd@faultfalse\fi}
% AFTER ``FIX'':
% \def\LGend{\ifLGd@fault\egroup\ifLGinline$\else$$\fi\LGd@faultfalse\fi\LGinlinefalse}
% Problem is that without this fix, any lgrindfile{} or
% begin{lgrind}...end{lgrind} gets all put on one line.

% Another bug with lgrind is that it is no longer possible to use \@
% before a `.', `?' or `!'.

% Turn off special handling of vertical bars, else problems with
%tabular.
%|-

% These two lines fix up the overwritten page number problem in the
% table of contents:  Nick, 6-12-94.
\renewcommand\@pnumwidth{3.55em}
\renewcommand\@tocrmarg {4.55em}


