\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{lettern}[1994/08/24 Nick's letter class]


\DeclareOption*{%
   \PassOptionsToClass{\CurrentOption}{letter}%
}
\ProcessOptions
\LoadClass[a4paper]{letter}

% \begin{macro}{\closing}
%     The body of the letter follows, ended by a |\closing| command,
%     as in
%\begin{verbatim}
%            \closing{Yours truly,}
%\end{verbatim}
%     This commands generates the closing matter, and the signature.
%     An obvious thing to do is to use a |\parbox| for the closing
%     and the signature.  Should use the following:
%    \begin{itemize}
%      \item |\fromsig| : argument of current |\signature| declaration
%                   or, if null, the |\fromname|.
%      \item |\stopbreaks| : a macro that inhibits page breaking.
%    \end{itemize}
%    \begin{macrocode}
\long\def\leftClosing#1{\par\nobreak\vspace{\parskip}%
  \stopbreaks
  \noindent
  \ifx\@empty\fromaddress
  % \else\hspace*{\longindentation}
  \fi
  \parbox{\textwidth}{\raggedright
       \ignorespaces #1\\[6\medskipamount]%
       \ifx\@empty\fromsig
           \fromname
       \else \fromsig \fi\strut}%
   \par}
%    \end{macrocode}
% \end{macro}

% Want \today to give: day Month year
\renewcommand\today{\number\day\space
  \ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space \number\year}

\endinput

