% File: vtcmemo.cls
% For VTC memoe.
% Options: All article options and also:
% 
% Written by Nick Urbanik, 14-11-94

% $Header: D:\emtex\texinput\RCS\vtcmemo.cls 1.1 1994/12/09 21:58:46 Nick Exp Nick $

% $Log: vtcmemo.cls $
% Revision 1.1  1994/12/09  21:58:46  Nick
% Initial revision
%
% Identification part

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{vtcmemo}[1994/11/14 For VTC memos]

% Declaration of options

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

% Execution of options

\ProcessOptions

% Special class file commands

\LoadClass[a4paper,12pt]{article}

% Package loading

\RequirePackage{nick,vmargin,emlines2,result,fancyhea,xspace}


\setpapersize{A4}
\setmarginsrb{30mm}% left
             {10mm}% top
             {30mm}% right
             {10mm}% bottom
             {24pt}% headheight---increase to stop fancyhead warn
             {8mm}%  headsep
             {0pt}%  footheight
             {11mm}% footskip

\setmarginsrb{30mm}{10mm}{30mm}{15mm}{12pt}{11mm}{0pt}{11mm}

\setlength{\footrulewidth}{0pt}
%\setlength{\headrulewidth}{0pt}
\addtolength{\headheight}{3pt}
%
%     \lhead[\fancyplain{plain LH-even}{normal LH-even}]{\fancyplain{plain LH-odd}{normal LH-odd}}
%     \rhead[\fancyplain{plain RH-even}{normal RH-even}]{\fancyplain{plain RH-odd}{normal RH-odd}}
%
\lhead{\fancyplain{}{\textrm{\textbf{\footnotesize\subjectHeading}}}}
\rhead{\fancyplain{}{\textrm{\textbf{\thepage}}}}
\cfoot{}
\lfoot{\fancyplain{\fromInitials}{\fromInitials}}
\rfoot{}

\pagestyle{fancyplain}

\newcommand\initials[1]{\def\fromInitials{#1}} % NU
\newcommand\useVia[1]{\def\via{#1}} % via
\newcommand\thisDate[1]{\def\fromDate{#1}}  % \today
\newcommand\phone[1]{\def\fromPhone{#1}} % 436 8660
\newcommand\myIn[1]{\def\fromMyIn{#1}}  % TYEE/54
\newcommand\from[1]{\def\fromName{#1}} % Dennis Leung
\newcommand\myRef[1]{\def\fromMyRef{#1}} % (47)
\newcommand\yourRef[1]{\def\toYourRef{#1}} % (37)
\newcommand\yourIn[1]{\def\toYourIn{#1}} % TYEE/34
\newcommand\viaWho[1]{\def\viaWhom{#1}} % Eric Mok
\newcommand\toWho[1]{\def\toWhom{#1}} % DED (TC)
\newcommand\dated[1]{\def\toDated{#1}} % 10 October 1994
\DeclareRobustCommand\subject[1]{\def\subjectHeading{#1}}

\initials{}
\useVia{}
\thisDate{}
\phone{}
\myIn{}
\from{}
\myRef{}
\yourRef{}
\yourIn{}
\viaWho{}
\toWho{}
\dated{}

\newcommand{\memosize}{\small}

\providecommand{\college}{Hong Kong Technical College (Tsing Yi)}
\providecommand{\department}%
      {Department of Electrical and Communications Engineering}
\providecommand{\up}{microprocessor\xspace}
\providecommand{\Up}{Microprocessor\xspace}
\providecommand{\ie}{i.e.,\xspace}
\providecommand{\eg}{e.g.,\xspace}

% Have moved \eemph into nick.sty, since it is so usefull.
% \providecommand{\eemph}[1]{\emph{\textbf{#1}}}


% This stops the warnings about overfull boxes on each page, with
% fancypage.sty:
\addtolength{\headheight}{2.5pt}


\newcommand{\memoHead}{%
\thispagestyle{plain}
% These dims work with A4wide.sty:
% \vspace*{-3.5cm}
% \hspace*{-1.5cm}\input{memo.pic}
%
% These dimensions work with those for vmargin, given above.
\vspace*{-21mm}
\hspace*{-20.5mm}%
\unitlength=1.00mm
\special{em:linewidth 1pt}
\linethickness{1pt}
\begin{picture}(187.06,50.00)
\emline{0.00}{0.00}{1}{187.06}{0.00}{2}
\emline{0.00}{1.00}{3}{187.06}{1.18}{4}
\emline{94.00}{1.00}{5}{94.12}{34.12}{6}
\emline{86.00}{34.00}{7}{101.96}{34.12}{8}
\put(94.00,35.00){\makebox(0,0)[cb]{\textsf{\textbf{\large MEMO}}}}
\put(177.00,43.00){\circle{14.00}}
\put(0.00,4.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize Date}} {\tiny\dotfill}}}
\put(0.00,12.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize Tel. No.}}{\tiny\dotfill}}}
\put(0.00,20.00){\makebox(22,0)[lb]{\textsf{\textsl{\memosize Ref.}} {\tiny\dotfill}}}
\put(22.00,20.00){\makebox(63,0)[lb]{\textsf{\textsl{\memosize in}}{\tiny\dotfill}}}
\put(0.00,28.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize From}}{\tiny\dotfill}}}
\put(102.00,4.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize dated}}{\tiny\dotfill}}}
\put(102.00,12.00){\makebox(30,0)[lb]{\textsf{\textsl{\memosize Your Ref.}}{\tiny\dotfill}}}
\put(132.00,12.00){\makebox(55,0)[lb]{\textsf{\textsl{\memosize in}}{\tiny\dotfill}}}
\put(102.00,20.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize \via}}}}
\put(102.00,28.00){\makebox(85,0)[lb]{\textsf{\textsl{\memosize To}}{\tiny\dotfill}}}
% How to shift the data on the dotted lines left or right?
% The \put statement positions the begining of the field.
% The \makebox{} command just prints the text at the position given by the
% \put statement.
\put(27.00,5.00){\makebox(0,0)[lb]{\fromDate}}
\put(27.00,13.00){\makebox(0,0)[lb]{\fromPhone}}
\put(27.00,21.00){\makebox(0,0)[lb]{\fromMyIn}}
\put(27.00,29.00){\makebox(0,0)[lb]{\fromName}}
\put(10.00,21.00){\makebox(0,0)[lb]{\fromMyRef}}
\put(120.00,13.00){\makebox(0,0)[lb]{\toYourRef}}
\put(140.00,13.00){\makebox(0,0)[lb]{\toYourIn}}
% These two are often long, hence need to be further to the left.
\put(110.00,21.00){\makebox(0,0)[lb]{\viaWhom}} % was (120.00,21.00)
\put(110.00,29.00){\makebox(0,0)[lb]{\toWhom}} % was (120.00,29.00)
\put(120.00,5.00){\makebox(0,0)[lb]{\toDated}}
\end{picture}


\begin{center}
\large\bfseries \subjectHeading
\end{center}

\vspace{2ex}
}

